﻿using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound
{
    /// <summary>
    /// Serialize Request Step.
    /// </summary>
    public class SerializeRequestStep : FilterBase<MakeCancelOutboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelOutboundStateObject state)
        {
            state.SerializedRequestMessage = PipelineUtilities.SerializeInstance(state.RequestMessage);
            Logger.Instance.Info($"INFO: HealthShare Make Cancel Outbound Request: {state.SerializedRequestMessage}");
        }
    }
}